/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipes;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import org.openzen.zenscript.codemodel.Modifiers;

public final class RecipeHandlerRegistry {
    private final Map<Class<? extends IRecipe<?>>, IRecipeHandler<?>> recipeHandlers = new HashMap();

    public void addClass(Class<?> clazz) {
        if (!IRecipeHandler.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " does not implement IRecipeHandler");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is an interface and cannot be annotated with @IRecipeHandler.For");
        }
        if (Modifiers.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is an abstract class and cannot be annotated with @IRecipeHandler.For");
        }
        Arrays.stream(clazz.getAnnotationsByType(IRecipeHandler.For.class)).map(IRecipeHandler.For::value).filter(it -> it != IRecipe.class).forEach(it -> {
            if (this.recipeHandlers.containsKey(it)) {
                CraftTweakerAPI.logWarning("Multiple recipe handlers found for the same recipe class %s: attempted registration of %s, using %s", it.getName(), clazz.getName(), this.recipeHandlers.get(it).getClass().getName());
            } else {
                this.recipeHandlers.put((Class<IRecipe<?>>)it, (IRecipeHandler)InstantiationUtil.getOrCreateInstance(clazz));
            }
        });
    }

    public <T extends IRecipe<?>> IRecipeHandler<T> getHandlerFor(T recipe) {
        return this.getHandlerFor(recipe.getClass()).orElse(DefaultRecipeHandler.INSTANCE);
    }

    private Optional<IRecipeHandler<?>> getHandlerFor(Class<?> recipeClass) {
        ArrayDeque classes = new ArrayDeque();
        classes.offer(recipeClass);
        while (!classes.isEmpty()) {
            Class target = (Class)classes.poll();
            if (target == IRecipe.class) continue;
            IRecipeHandler<?> attempt = this.recipeHandlers.get(target);
            if (attempt != null) {
                return Optional.of(attempt);
            }
            if (target.getSuperclass() != null) {
                classes.offer(target.getSuperclass());
            }
            Arrays.stream(target.getInterfaces()).forEach(classes::offer);
        }
        return Optional.empty();
    }

    private static final class DefaultRecipeHandler
    implements IRecipeHandler<IRecipe<?>> {
        private static final DefaultRecipeHandler INSTANCE = new DefaultRecipeHandler();

        private DefaultRecipeHandler() {
        }

        @Override
        public String dumpToCommandString(IRecipeManager manager, IRecipe<?> recipe) {
            return String.format("~~ Recipe name: %s, Outputs: %s, Inputs: [%s], Recipe Class: %s, Recipe Serializer: %s ~~", recipe.func_199560_c(), new MCItemStackMutable(recipe.func_77571_b()).getCommandString(), recipe.func_192400_c().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ")), recipe.getClass().getName(), recipe.func_199559_b().getRegistryName());
        }
    }
}

